package tomek.java.itjp.log2;

/*
	https://logging.apache.org/log4j/2.x/download.html

	Using Log4j on your classpath
	
	To use Log4j 2 in your application make sure that both the API and Core jars are in the application’s classpath. Add the dependencies listed below to your classpath.
	
	log4j-api-2.13.2.jar
	log4j-core-2.13.2.jar
	
	You can do this from the command line or a manifest file.	
*/

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class Class201 {


	// Levels: TRACE, DEBUG, INFO, WARN, ERROR and FATAL	
	static final Logger log = LogManager.getRootLogger();

	public static void main(String[] args) {

		// Set up a simple configuration that logs on the console.
		Configurator.initialize(new DefaultConfiguration());
	    Configurator.setRootLevel(Level.INFO);
	    
		log.trace("Entering application (trace).");
		log.debug("Entering application (debug).");
		log.info("Entering application (info).");
		log.warn("Entering application (warn).");
		log.error("Entering application (error).");
		log.fatal("Entering application (fatal).");
		
		System.out.println("Application is working");
		
		log.info("Exiting application.");
	}
}